/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.Tier;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.item.WrenchItem;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.client.handler.IHud;
import owmii.powah.lib.client.util.Draw;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.util.Util;
import owmii.powah.lib.util.math.V3d;

public class EnergizingRodBlock
extends AbstractEnergyBlock<EnergyConfig, EnergizingRodBlock>
implements class_3737,
IWrenchable,
IHud {
    public EnergizingRodBlock(class_4970.class_2251 properties, Tier variant) {
        super(properties, variant);
        this.setStateProps(state -> (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11033));
        this.shapes.put(class_2350.field_11036, class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (class_265)class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 13.0, 7.0, 9.0, 16.0, 9.0), (class_265)EnergizingRodBlock.box(7.25, 9.0, 7.25, 8.75, 13.0, 8.75), (class_247)class_247.field_1366), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11033, class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (class_265)class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 0.0, 7.0, 9.0, 3.0, 9.0), (class_265)EnergizingRodBlock.box(7.25, 3.0, 7.25, 8.75, 7.0, 8.75), (class_247)class_247.field_1366), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11043, class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (class_265)class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 7.0, 0.0, 9.0, 9.0, 3.0), (class_265)EnergizingRodBlock.box(7.25, 7.25, 3.0, 8.75, 8.75, 7.0), (class_247)class_247.field_1366), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11035, class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (class_265)class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 7.0, 13.0, 9.0, 9.0, 16.0), (class_265)EnergizingRodBlock.box(7.25, 7.25, 13.0, 8.75, 8.75, 9.0), (class_247)class_247.field_1366), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11039, class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (class_265)class_259.method_1072((class_265)EnergizingRodBlock.box(0.0, 7.0, 7.0, 3.0, 9.0, 9.0), (class_265)EnergizingRodBlock.box(3.0, 7.25, 7.25, 7.0, 8.75, 8.75), (class_247)class_247.field_1366), (class_247)class_247.field_1366));
        this.shapes.put(class_2350.field_11034, class_259.method_1072((class_265)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (class_265)class_259.method_1072((class_265)EnergizingRodBlock.box(13.0, 7.0, 7.0, 16.0, 9.0, 9.0), (class_265)EnergizingRodBlock.box(13.0, 7.25, 7.25, 9.0, 8.75, 8.75), (class_247)class_247.field_1366), (class_247)class_247.field_1366));
    }

    @Override
    public EnergyBlockItem getBlockItem(class_1792.class_1793 properties, @Nullable class_5321<class_1761> group) {
        return super.getBlockItem(properties.method_7889(1), (class_5321)group);
    }

    @Override
    public EnergyConfig getConfig() {
        return Powah.config().devices.energizing_rods;
    }

    @Override
    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new EnergizingRodTile(pos, state, (Tier)this.variant);
    }

    @Override
    protected boolean checkValidEnergySide() {
        return true;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, worldIn, pos, oldState, isMoving);
        class_2586 tileEntity = worldIn.method_8321(pos);
        if (tileEntity instanceof EnergizingRodTile) {
            this.setOrbPos(worldIn, pos, (EnergizingRodTile)tileEntity);
        }
    }

    public void setOrbPos(class_1937 worldIn, class_2338 pos, EnergizingRodTile tile) {
        int range = Powah.config().general.energizing_range;
        List list = class_2338.method_20437((class_2338)pos.method_10069(-range, -range, -range), (class_2338)pos.method_10069(range, range, range)).map(class_2338::method_10062).collect(Collectors.toList());
        for (class_2338 pos1 : list) {
            class_2586 tileEntity1;
            if (pos1.equals((Object)class_2338.field_10980) || !((tileEntity1 = worldIn.method_8321(pos1)) instanceof EnergizingOrbTile)) continue;
            tile.setOrbPos(pos1);
            break;
        }
    }

    @Override
    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    @Override
    public boolean onWrench(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_2350 side, WrenchMode mode, class_243 hit) {
        class_1799 stack;
        if (mode.link() && (stack = player.method_5998(hand)).method_7909() instanceof WrenchItem) {
            WrenchItem wrench = (WrenchItem)stack.method_7909();
            class_2586 tileEntity = world.method_8321(pos);
            if (tileEntity instanceof EnergizingRodTile) {
                EnergizingRodTile rod = (EnergizingRodTile)tileEntity;
                class_2487 nbt = wrench.getWrenchNBT(stack);
                if (nbt.method_10573("OrbPos", 10)) {
                    class_2338 orbPos = class_2512.method_10691((class_2487)nbt.method_10562("OrbPos"));
                    class_2586 tileEntity1 = world.method_8321(orbPos);
                    if (tileEntity1 instanceof EnergizingOrbTile) {
                        EnergizingOrbTile orb = (EnergizingOrbTile)tileEntity1;
                        V3d v3d = V3d.from(orbPos);
                        if ((int)v3d.distance(pos) <= Powah.config().general.energizing_range) {
                            rod.setOrbPos(orbPos);
                            player.method_7353((class_2561)class_2561.method_43471((String)"chat.powah.wrench.link.done").method_27692(class_124.field_1065), true);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43471((String)"chat.powah.wrench.link.fail").method_27692(class_124.field_1061), true);
                        }
                    }
                    nbt.method_10551("OrbPos");
                } else {
                    nbt.method_10566("RodPos", (class_2520)class_2512.method_10692((class_2338)pos));
                    player.method_7353((class_2561)class_2561.method_43471((String)"chat.powah.wrench.link.start").method_27692(class_124.field_1054), true);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderHud(class_332 gui, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 result, @Nullable class_2586 te) {
        if (te instanceof EnergizingRodTile) {
            EnergizingRodTile rod = (EnergizingRodTile)te;
            RenderSystem.getModelViewStack().method_22903();
            RenderSystem.enableBlend();
            class_310 mc = class_310.method_1551();
            class_327 font = mc.field_1772;
            int x = mc.method_22683().method_4486() / 2;
            int y = mc.method_22683().method_4502();
            String s = class_124.field_1080 + class_1074.method_4662((String)"info.lollipop.stored", (Object[])new Object[0]) + ": " + class_1074.method_4662((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(rod.getEnergy().getEnergyStored()), Util.numFormat(rod.getEnergy().getCapacity())});
            RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960("lollipop", "textures/gui/ov_energy.png"));
            Draw.drawTexturedModalRect(gui, x - 37 - 1, y - 80, 0, 0, 74, 9, 0.0f);
            Draw.gaugeH(x - 37, y - 79, 72, 16, 0, 9, ((EnergizingRodTile)te).getEnergy());
            gui.method_25303(font, s, Math.round((float)x - (float)font.method_1727(s) / 2.0f), y - 67, 0xFFFFFF);
            RenderSystem.disableBlend();
            RenderSystem.getModelViewStack().method_22909();
        }
        return true;
    }
}

